import { ReactNode } from "@tanstack/react-router";
import { logger } from "../notifications";
import { ManualAbortError } from "./manual-abort.error";

export function isManualAbortError(err: Error) {
    return err instanceof ManualAbortError
}

export function HandleToastError(err: unknown): ReactNode {
    if (err instanceof ManualAbortError) {
        return "Request was manually aborted"
    } else {
        logger.error(err);
        return err
    }
}